// $Id: CBrush.cpp,v 1.3 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CBrush.hpp"
using Exponent::GUI::Graphics::CBrush;

//	===========================================================================
CBrush::CBrush()
#ifdef WIN32
	  : m_hdc(NULL)
	  , m_hOld(NULL)
	  , m_brush(NULL)
#else
	  : m_drawContext(NULL)
#endif
{
#ifdef WIN32
	NULL_POINTER(m_hdc);
#else
	NULL_POINTER(m_drawContext);
#endif
}

//	===========================================================================
CBrush::~CBrush()
{
	this->deleteBrush();
}

#ifdef WIN32
//	===========================================================================
void CBrush::initialise(HDC hdc, const CAlphaColour &colour)
{
	m_hdc = hdc;
	this->setColour(colour);
	this->createBrush();
}
#else
void CBrush::initialise(CGContextRef drawContext, const CAlphaColour &colour)
{
	m_drawContext = drawContext;
	this->setColour(colour);
}
#endif

//	===========================================================================
void CBrush::uninitialise()
{
	this->deleteBrush();
}

#ifdef WIN32
//	===========================================================================
void CBrush::setColourToNullBrush()
{
	DeleteObject(m_brush);
	m_brush = (HBRUSH)GetStockObject(NULL_BRUSH);
	m_hOld  = SelectObject(m_hdc, m_brush);
}
#endif

//	===========================================================================
void CBrush::setColour(const CAlphaColour &colour)
{
	m_colour = colour;
#ifdef WIN32
	this->createBrush();
#else
	CGContextSetRGBFillColor(m_drawContext, colour.getRed() / 255.f, colour.getGreen() / 255.f, colour.getBlue() / 255.f, colour.getAlpha() / 255.f);	// Alpha can be done here
#endif
}

//	===========================================================================
void CBrush::createBrush()
{
#ifdef WIN32
	DeleteObject(m_brush);
	m_brush = CreateSolidBrush(m_colour.getAsColourRef());
	m_hOld  = SelectObject(m_hdc, m_brush);
#endif
}

//	===========================================================================
void CBrush::deleteBrush()
{
#ifdef WIN32
	if (m_hdc)
	{
		SelectObject(m_hdc, m_hOld);
		m_hdc  = NULL;
		m_hOld = NULL;
	}
	DeleteObject(m_brush);
#endif
}